use "${tmp}/Regfile_nafZE", clear

drop E_* HE* EP*_* _merge

	rename mainlabex labexid
	merge m:1 labexid using "${tmp}/main_labex_with_ctrf", nogen keep(1 3) 
	rename accept max_accept
	drop if ape == ""
	rename note_totale max_note
	xtset gp year
	sort gp year
	
	gen tx = log(job_eng_sbrut / L.job_eng_sbrut)
	winsor2 tx, by(year) cuts(1 99) replace 
	bys ape ZE2010: egen sum_nonmi = sum((tx!=.)*(year > 2010))
	bys ape ZE2010: egen tx_post = sum(tx*(year > 2010)/sum_nonmi)	
	drop sum_nonmi
	bys ape ZE2010: egen sum_nonmi = sum((tx!=.)*(year <= 2010))
	bys ape ZE2010: egen tx_pre = sum(tx*(year <= 2010)/sum_nonmi)	
	drop sum_nonmi	
	cap drop _merge
	
	gen note_r = round(max_note)
	gen note_r30 = max_note >= 30
	reg max_accept note_r30  if year == 2010 , vce(cluster labexid)
	keep if e(sample)

	qui tab note_r, gen(e_)
	
	replace exposure = log(exposure + 1)
	
	
	local row0 = "& P(accepted) & Exposure & Post-reform R&D growth rate & Pre-reform R&D growth rate \\"
	
	local row1 = "Baseline "
	local row2 = "  "
	
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex > 0 &  inlist(note_r, 29, 31), noabsorb vce(cluster labexid)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row1 = "`row1' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row2 = "`row2' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	local row1 = "`row1' \\"
	local row2 = "`row2' \\"
	

	
	local row3 = "Robustness \\"
	
	local row4 = "1. Only strong links (share \geq 0.5) "
	local row5 = ""
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex >= 0.5 &  inlist(note_r, 29, 31), noabsorb vce(cluster labexid)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row4 = "`row4' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row5 = "`row5' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	
	local row4 = "`row4' \\"
	local row5 = "`row5' \\"
	
	
	local row6 = "2. Only strong links (share \geq 0.9) "
	local row7 = ""
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex >= 0.9 &  inlist(note_r, 29, 31), noabsorb vce(cluster labexid)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row6 = "`row6' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row7 = "`row7' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	
	local row6 = "`row6' \\"
	local row7 = "`row7' \\"
		
		
		
	local row8 = "3. including grade 30 "
	local row9 = ""
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex >= 0 &  inlist(note_r, 29, 30, 31), noabsorb vce(cluster labexid)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row8 = "`row8' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row9 = "`row9' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	
	local row8 = "`row8' \\"
	local row9 = "`row9' \\"
	
	
	local j = 8
	forvalues i = 32/35 {
		local j = `j'+2
		local k = `j'+1
	local row`j' = "`=i-28'. Broader gradde window (\leq `i')"
	local row`k' = ""
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex >= 0 &  (inlist(note_r, 29, 31) | (note_r >= 31 & note_r <= `i')), noabsorb vce(cluster labexid)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row`j' = "`row`j'' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row`k' = "`row`k'' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	
	local row`j' = "`row`j'' \\"
	local row`k' = "`row`k'' \\"
	}
	
	local row18 = "8. Clustering at the pair level "
	local row19 = "  "
	
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex > 0 &  inlist(note_r, 29, 31), noabsorb cluster(ape_n ZE2010)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row18 = "`row18' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row19 = "`row19' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	local row18 = "`row18' \\"
	local row19 = "`row19' \\"
	
	local row20 = "9. Clustering at the CZ level "
	local row21 = "  "
	
	foreach var of varlist max_accept exposure tx_post tx_pre {
		reghdfe `var' note_r30 if share_exposure_maxlabex > 0 &  inlist(note_r, 29, 31), noabsorb cluster(ZE2010)
	
		qui prog_addstar, b(`=_b[note_r30]') se(`=_se[note_r30]') n(`=e(N)')
	
		local row20 = "`row20' & `=string(_b[note_r30],  "%9.4f")'`=e(star)'"
		local row21 = "`row21' &  (`=string(_se[note_r30],  "%9.4f")')"
	}
	local row20 = "`row20' \\"
	local row21 = "`row21' \\"
	
	
			file open myfile using "${outpath}/tableA5.tex", write text replace
	forvalues i = 0/21 {
		file write myfile " `row`i''" _n
	}
	file close myfile